texture Tex;

sampler2D g_samSrcColor =
sampler_state
{
    Texture = <Tex>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Point;
};

texture Tex1;
sampler2D g_samSceneColor = sampler_state
{
    Texture = <Tex1>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
};

// Vertex Shader 
struct VS_INPUT 
{ 
   float4 position : POSITION; 
   float2 texCoord : TEXCOORD; 
}; 
struct VS_OUTPUT 
{ 
   float4 position : POSITION; 
   float2 texCoord : TEXCOORD;    
}; 
#define PS_INPUT VS_OUTPUT 

VS_OUTPUT vs_main(const VS_INPUT IN) 
{ 
   VS_OUTPUT OUT; 
    
   OUT.position = IN.position; 
   OUT.texCoord = IN.texCoord; 

   return OUT; 
} 

float2 PixelCoordsDownFilter[16] =
{
    { 1.5,  -1.5 },
    { 1.5,  -0.5 },
    { 1.5,   0.5 },
    { 1.5,   1.5 },

    { 0.5,  -1.5 },
    { 0.5,  -0.5 },
    { 0.5,   0.5 },
    { 0.5,   1.5 },

    {-0.5,  -1.5 },
    {-0.5,  -0.5 },
    {-0.5,   0.5 },
    {-0.5,   1.5 },

    {-1.5,  -1.5 },
    {-1.5,  -0.5 },
    {-1.5,   0.5 },
    {-1.5,   1.5 },
};

float2 TexelCoordsDownFilter[16]
<
    string ConvertPixelsToTexels = "PixelCoordsDownFilter";
>;


float4 DownFilter( in float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;

    for (int i = 0; i < 16; i++)
    {
        Color += tex2D( g_samSrcColor, Tex + TexelCoordsDownFilter[i].xy );
    }

    return Color / 16;
}

technique PostProcessDown
{
    pass p0
    <
        float fScaleX = 0.25f;
        float fScaleY = 0.25f;
    >
    {
        VertexShader = compile vs_1_1 vs_main();
        PixelShader = compile ps_2_0 DownFilter();
        ZEnable = false;
		AlphaBlendEnable = false;
    }
}

static const int g_cKernelSize = 13;

float2 PixelKernel_v[g_cKernelSize] =
{
    { 0, -6 },
    { 0, -5 },
    { 0, -4 },
    { 0, -3 },
    { 0, -2 },
    { 0, -1 },
    { 0,  0 },
    { 0,  1 },
    { 0,  2 },
    { 0,  3 },
    { 0,  4 },
    { 0,  5 },
    { 0,  6 },
};

float2 TexelKernel_v[g_cKernelSize]
<
    string ConvertPixelsToTexels = "PixelKernel_v";
>;

static const float BlurWeights[g_cKernelSize] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

float BloomScale = 1.0f;

float4 PostProcessPS_v( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;

    for (int i = 0; i < g_cKernelSize; i++)
    {    
        Color += tex2D( g_samSrcColor, Tex + TexelKernel_v[i].xy ) * BlurWeights[i];
    }

    return Color * BloomScale;
}

technique PostProcessVBlur
<
    string Parameter0 = "BloomScale";
    float4 Parameter0Def = float4( 1.5f, 0, 0, 0 );
    int Parameter0Size = 1;
    string Parameter0Desc = " (float)";
>
{
    pass p0
    {
        VertexShader = compile vs_1_1 vs_main();
        PixelShader = compile ps_2_0 PostProcessPS_v();
        ZEnable = false;
		AlphaBlendEnable = false;
    }
}

float2 PixelKernel_h[g_cKernelSize] =
{
    { -6, 0 },
    { -5, 0 },
    { -4, 0 },
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
};

float2 TexelKernel_h[g_cKernelSize]
<
    string ConvertPixelsToTexels = "PixelKernel_h";
>;

float4 PostProcessPS_h( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;

    for (int i = 0; i < g_cKernelSize; i++)
    {    
        Color += tex2D( g_samSrcColor, Tex + TexelKernel_h[i].xy ) * BlurWeights[i];
    }

    return Color * BloomScale;
}


technique PostProcessHBlur
<
    string Parameter0 = "BloomScale";
    float4 Parameter0Def = float4( 1.5f, 0, 0, 0 );
    int Parameter0Size = 1;
    string Parameter0Desc = " (float)";
>
{
    pass p0
    {
        VertexShader = compile vs_1_1 vs_main(); 
        PixelShader = compile ps_2_0 PostProcessPS_h();
        ZEnable = false;
		AlphaBlendEnable = false;
    }
}

float4 Combine( float2 Tex : TEXCOORD0,
                float2 Tex1 : TEXCOORD1 ) : COLOR0
{
    float3 ColorOrig = tex2D( g_samSceneColor, Tex );

    ColorOrig += tex2D( g_samSrcColor, Tex );

    return float4( ColorOrig, 1.0f );
}

technique PostProcessCombine
{
    pass p0
    <
        float fScaleX = 4.0f;
        float fScaleY = 4.0f;
    >
    {
        VertexShader = compile vs_1_1 vs_main();
        PixelShader = compile ps_2_0 Combine();
        ZEnable = false;
		AlphaBlendEnable = false;
    }
}
